<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Admin extends Model 
{

    protected $table = 'admins';
    public $timestamps = true;
    protected $fillable = array('email', 'password', 'name', 'phone', 'photo', 'pin_code', 'verification_token', 'token_created_at', 'pin_created_at', 'confirmed_email', 'email_verified_at', 'company_id', 'is_approved', 'approved_by');

    public function company()
    {
        return $this->hasOne('App\Models\Company');
    }

    public function hasRole()
    {
        return $this->belongsTo('App\Model\Role');
    }

}